// StreetDlg.cpp : implementation file
//

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

#include "stdafx.h"
#include "Addr.h"
#include "StreetDlg.h"
#include <atlbase.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CStreetDlg dialog

CStreetDlg::CStreetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStreetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStreetDlg)
	m_Build_Number = _T("");
	m_Database_Date = _T("");
	m_Init_Err_Str = _T("");
	m_Zipcode = _T("");
	m_Street = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	street = NULL;
	streetCreated = false;
	parse = NULL;

	//Initialize the COM library
	CoInitialize(0);
}

CStreetDlg::~CStreetDlg()
{
	//Release the Address Object

	if (street)
	{
		street->Release();
		street = NULL;
	}

	//Uninitializes the COM library
	CoUninitialize();
}

void CStreetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStreetDlg)
	DDX_Control(pDX, IDC_OUTPUT, m_Output);
	DDX_Text(pDX, IDC_BUILD_NUMBER, m_Build_Number);
	DDX_Text(pDX, IDC_DB_DATE, m_Database_Date);
	DDX_Text(pDX, IDC_INIT_ERR, m_Init_Err_Str);
	DDX_Text(pDX, IDC_ZIPCODE, m_Zipcode);
	DDX_Text(pDX, IDC_STREETNAME, m_Street);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStreetDlg, CDialog)
	//{{AFX_MSG_MAP(CStreetDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_FIND_STREET, OnFindStreet)
	//ON_BN_CLICKED(IDC_BUTTON1, AddressInRange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStreetDlg message handlers

BOOL CStreetDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	try
	{
		// New COM - AddressCoder Object - StreetData interface
		street = new IStreetDataPtr(__uuidof(StreetData));
		parse = new IParsePtr(__uuidof(Parse));

		streetCreated = true;
		parseCreated = true;
		initStreet();
		//Update input with default values;
		UpdateData();
		m_Street="Main St.";
		m_Zipcode="89101";
		UpdateData(false);

	}
	catch(const _com_error &e)
	{
		AfxMessageBox(e.ErrorMessage());
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStreetDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		//CAboutDlg dlgAbout;
		//dlgAbout.DoModal();
		int x=0;
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CStreetDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CStreetDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CStreetDlg::OnCancel()
{
	CDialog::OnCancel();
}

void CStreetDlg::OnClear()
{
	//Function clears data
	m_Output.ResetContent();
	m_Street.Empty();
	m_Zipcode.Empty();

	UpdateData(FALSE);

}

void CStreetDlg::OnFindStreet()
{
	//Clear the output field for neatness.
	m_Output.ResetContent();
	//Needed to handle the BSTR's
	CComBSTR retStr;
	CString cBuff,cTemp;

	UpdateData();

	//Parsing the initial street value
	parse->Parse((LPCTSTR)m_Street);
	_bstr_t pStreet((LPCTSTR)m_Street);
	//Storing the input zip.
	_variant_t pZip((LPCTSTR)m_Zipcode);

	//Testing if FindStreet has any data
	if (street->FindStreet(parse->GetStreetName(), pZip,"0") == 0)
	{
		//Test failed, display message and return
		AfxMessageBox("Unable to locate Street in ZIP Code.");
		return;
	}
	else
	{
		//successful, show initial data.

		cBuff.Empty();


		retStr = (LPCOLESTR) street->PrimaryRangeLow;
		cTemp=retStr.Detach();
		cBuff=cTemp;

		retStr = (LPCOLESTR)street->PrimaryRangeHigh;
		cTemp=retStr.Detach();
		cBuff+="-"+cTemp;

		retStr = (LPCOLESTR)street->PrimaryRangeOddEven;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->PreDirection;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->StreetName;
		cTemp=retStr.Detach();
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->Suffix;
		cTemp=retStr.Detach() ;
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->PostDirection;
		cTemp=retStr.Detach() ;
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->SuiteName;
		cTemp=retStr.Detach() ;
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->SuiteRangeLow;
		cTemp=retStr.Detach() ;
		cBuff+="-"+cTemp;
		retStr = (LPCOLESTR)street->SuiteRangeHigh;
		cTemp=retStr.Detach() ;
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->SuiteRangeOddEven;
		cTemp=retStr.Detach() ;
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->Zip;
		cTemp=retStr.Detach() ;
		cBuff+=" "+cTemp;
		retStr = (LPCOLESTR)street->Plus4Low;
		cTemp=retStr.Detach() ;
		cBuff+="-"+cTemp;
		retStr = (LPCOLESTR)street->Plus4High;
		cTemp=retStr.Detach() ;
		cBuff+=" "+cTemp;

		m_Output.AddString((LPCTSTR)cBuff);

		//Now trying to get the next data.
		//Loop until there is no more next data.
		while (street->FindStreetNext() != 0)
		{
			//Printing the properties.
			cBuff.Empty();


			retStr = (LPCOLESTR) street->PrimaryRangeLow;
			cTemp=retStr.Detach();
			cBuff=cTemp;

			retStr = (LPCOLESTR)street->PrimaryRangeHigh;
			cTemp=retStr.Detach();
			cBuff+="-"+cTemp;

			retStr = (LPCOLESTR)street->PrimaryRangeOddEven;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->PreDirection;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->StreetName;
			cTemp=retStr.Detach();
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->Suffix;
			cTemp=retStr.Detach() ;
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->PostDirection;
			cTemp=retStr.Detach() ;
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->SuiteName;
			cTemp=retStr.Detach() ;
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->SuiteRangeLow;
			cTemp=retStr.Detach() ;
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->SuiteRangeHigh;
			cTemp=retStr.Detach() ;
			cBuff+="-"+cTemp;
			retStr = (LPCOLESTR)street->SuiteRangeOddEven;
			cTemp=retStr.Detach() ;
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->Zip;
			cTemp=retStr.Detach() ;
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->Plus4Low;
			cTemp=retStr.Detach() ;
			cBuff+=" "+cTemp;
			retStr = (LPCOLESTR)street->Plus4High;
			cTemp=retStr.Detach() ;
			cBuff+="-"+cTemp;
			m_Output.AddString((LPCTSTR)cBuff);
		}
	}

	UpdateData(FALSE);


}

bool CStreetDlg::initStreet()
{
	COleDateTime date;
	CComBSTR ccbString;

	street->SetLicenseString(_bstr_t(dLICENSE));
	if ( streetCreated == false )
		return false;

	UpdateData();

	//Here is where we call the Initialize method.
	//You must pass the paths to the mdaddr.dat, mdaddr.nat, & mdaddr.str data files
	if (street->Initialize(_bstr_t(dFILELOC),_bstr_t(dFILELOC),"") != 0)
	{
		// Error -- so let's find out what went wrong with a simple call to the
		// GetInitializeErrorString method
		ccbString = (LPCOLESTR)street->GetInitializeErrorString();

		//Pass the Error string back from a BSTR to a CString
		m_Init_Err_Str = ccbString.Detach();

		return false;
	}

	//the initialization was successful.

	// A call to the GetDatabaseDate method
	date = street->GetDatabaseDate();

	//Just a little Date manipulation so we can view the Date
	m_Database_Date.Format("%d/%d/%d", date.GetMonth(), date.GetDay(), date.GetYear());

	// A simple call to the GetBuildNumber method
	ccbString = (LPCOLESTR)street->GetBuildNumber();

	//BSTR to CString
	m_Build_Number = ccbString.Detach();

	//Just to show you the Error string returned from a successful Initialization
	ccbString = (LPCOLESTR)street->GetInitializeErrorString();

	//BSTR to CString
	m_Init_Err_Str = ccbString.Detach();

	streetInit = true;
	UpdateData(FALSE);

	return true;
}



